package automobile;

import java.util.Comparator;

/**
 * Permet le tri de voitures en fonction des kilomètres affichés au compteur
 * Implémente Comparator de Vehicule
 * @author Adrien Poupa
 */
public class CompteurComparator implements Comparator<Vehicule> {
    /**
     * Comparaison de deux voitures, tri par rapport à leur compteur
     * @param a Première voiture à tester
     * @param b Seconde voiture à tester
     * @return 1 si le compteur de a est supérieur au compteur de b, -1 s'il est inférieur, 0 si égal
     */
    @Override
    public int compare(Vehicule a, Vehicule b) {
        int compteurA = a.getCompteur().getTotalisateur(); // Compteur véhicule a
        int compteurB = b.getCompteur().getTotalisateur(); // Compteur véhicule b
        if (compteurA > compteurB) {
            return 1;
        }
        else if (compteurA < compteurB) {
            return -1;
        }
        return 0;
    }
}
